import random

plain_caption_dict = {
    0: "Go straight.",
    1: "Pass the intersection.",
    2: "Turn left.",
    3: "Turn right.",
    4: "Change to the left lane.",
    5: "Change to the right lane.",
    6: "Go to the left lane branch.",
    7: "Go to the right lane branch.",
    8: "Pass the crosswalk.",
    9: "Pass the railroad.",
    10: "Merge.",
    11: "Make a U-turn.",
    12: "Stop.",
    13: "Deviate."
}

diverse_caption_dict = {
    0: [
        "Move forward.",
        "Move steady.",
        "Go forward.",
        "Go straight.",
        "Proceed.",
        "Drive forward.",
        "Drive straight.",
        "Drive steady.",
        "Keep the direction.",
        "Maintain the direction.",
    ],
    1: [
        "Pass the intersection.",
        "Cross the intersection.",
        "Traverse the intersection.",
        "Drive through the intersection.",
        "Move past the intersection.",
        "Pass the junction.",
        "Cross the junction.",
        "Traverse the junction.",
        "Drive through the junction.",
        "Move past the junction.",
        "Pass the crossroad.",
        "Cross the crossroad.",
        "Traverse the crossroad.",
        "Drive through the crossroad.",
        "Move past the crossroad.",
    ],
    2: [
        "Turn left.",
        "Turn to the left.",
        "Make a left turn.",
        "Take a left turn.",
        "Turn to the left.",
        "Left turn.",
        "Steer left.",
        "Steer to the left.",
    ],
    3: [
        "Turn right.",
        "Turn to the right.",
        "Make a right turn.",
        "Take a right turn.",
        "Turn to the right.",
        "Right turn.",
        "Steer right.",
        "Steer to the right.",
    ],
    4: [
        "Make a left lane change.",
        "Change to the left lane.",
        "Switch to the left lane.",
        "Shift to the left lane.",
        "Move to the left lane.",
    ],
    5: [
        "Make a right lane change.",
        "Change to the right lane.",
        "Switch to the right lane.",
        "Shift to the right lane.",
        "Move to the right lane.",
    ],
    6: [
        "Go to the left lane branch.",
        "Take the left lane branch.",
        "Move into the left lane branch.",
        "Follow the left lane branch.",
        "Follow the left side road.",
    ],
    7: [
        "Go to the right lane branch.",
        "Take the right lane branch.",
        "Move into the right lane branch.",
        "Follow the right lane branch.",
        "Follow the right side road.",
    ],
    8: [
        "Pass the crosswalk.",
        "Cross the crosswalk.",
        "Traverse the crosswalk.",
        "Drive through the crosswalk.",
        "Move past the crosswalk.",
        "Pass the crossing area.",
        "Cross the crossing area.",
        "Traverse the crossing area.",
        "Drive through the crossing area.",
        "Move past the crossing area.",
    ],
    9: [
        "Pass the railroad.",
        "Cross the railroad.",
        "Traverse the railroad.",
        "Drive through the railroad.",
        "Move past the railroad.",
        "Pass the railway.",
        "Cross the railway.",
        "Traverse the railway.",
        "Drive through the railway.",
        "Move past the railway.",
    ],
    10: [
        "Merge.",
        "Merge traffic.",
        "Merge into traffic.",
        "Merge into the traffic.",
        "Join the traffic.",
        "Merge into the traffic flow.",
        "Join the traffic flow.",
        "Merge into the traffic stream.",
        "Join the traffic stream.",
        "Merge into the lane.",
    ],
    11: [
        "Make a U-turn.",
        "Make a 180-degree turn.",
        "Turn 180 degree.",
        "Turn around.",
        "Drive in a U-turn.",
    ],
    12: [
        "Stop.",
        "Halt.",
        "Decelerate.",
        "Slow down.",
        "Brake.",
    ],
    13: [
        "Deviate.",
        "Deviate from the path.",
        "Deviate from the lane.",
        "Change the direction.",
        "Shift the direction.",
    ]
}
diverse_command_dict = {
    0: [
        "Move forward.",
        "Please drive ahead.",
        "Could you go straight?",
        "Advance straight ahead.",
        "Let's proceed forward.",
        "Drive straight ahead, please.",
        "Keep moving in this direction.",
        "Maintain your course.",
        "Continue going forward.",
        "Push ahead."
    ],
    1: [
        "Pass the intersection.",
        "Could you cross the intersection?",
        "Let's move through the intersection.",
        "Drive past the intersection.",
        "Please navigate past the junction.",
        "Can you cross the junction?",
        "Traverse the junction, please.",
        "Drive through the junction.",
        "Continue past the crossroad.",
        "Let's go past the crossroad."
    ],
    2: [
        "Turn left.",
        "Can you turn to the left?",
        "Please make a left turn.",
        "Let's take a left turn.",
        "Could you steer left?",
        "Make a left turn here.",
        "Turn to the left side.",
        "Shift to the left, please."
    ],
    3: [
        "Turn right.",
        "Could you turn to the right?",
        "Please make a right turn.",
        "Let's take a right turn.",
        "Can you steer right?",
        "Make a right turn here.",
        "Turn to the right side.",
        "Shift to the right, please."
    ],
    4: [
        "Make a left lane change.",
        "Could you switch to the left lane?",
        "Please change to the left lane.",
        "Let's shift to the left lane.",
        "Can you move to the left lane?"
    ],
    5: [
        "Make a right lane change.",
        "Could you switch to the right lane?",
        "Please change to the right lane.",
        "Let's shift to the right lane.",
        "Can you move to the right lane?"
    ],
    6: [
        "Go to the left lane branch.",
        "Could you take the left lane branch?",
        "Please move into the left lane branch.",
        "Let's follow the left lane branch.",
        "Can you take the left side road?"
    ],
    7: [
        "Go to the right lane branch.",
        "Could you take the right lane branch?",
        "Please move into the right lane branch.",
        "Let's follow the right lane branch.",
        "Can you take the right side road?"
    ],
    8: [
        "Pass the crosswalk.",
        "Could you cross the crosswalk?",
        "Let's traverse the crosswalk.",
        "Drive through the crosswalk.",
        "Please move past the crosswalk."
    ],
    9: [
        "Pass the railroad.",
        "Could you cross the railroad?",
        "Let's traverse the railroad.",
        "Drive through the railroad.",
        "Please move past the railroad."
    ],
    10: [
        "Merge.",
        "Could you merge into traffic?",
        "Please join the traffic flow.",
        "Let's merge with the traffic.",
        "Can you merge into the lane?"
    ],
    11: [
        "Make a U-turn.",
        "Could you do a U-turn?",
        "Please perform a 180-degree turn.",
        "Let's turn around.",
        "Can you drive in a U-turn?"
    ],
    12: [
        "Stop.",
        "Could you halt the vehicle?",
        "Please decelerate.",
        "Let's slow down.",
        "Can you apply the brakes?"
    ],
    13: [
        "Deviate.",
        "Could you change the direction?",
        "Please shift the direction.",
        "Let's deviate from the path.",
        "Can you move away from the lane?"
    ]
}
diverse_command_dict_20 = {
    0: [
        "Move forward.",
        "Please drive ahead.",
        "Could you go straight?",
        "Advance straight ahead.",
        "Let's proceed forward.",
        "Drive straight ahead, please.",
        "Keep moving in this direction.",
        "Maintain your course.",
        "Continue going forward.",
        "Push ahead.",
        "Head straight down this road.",
        "Move directly forward.",
        "Proceed along this path.",
        "Could you advance straight?",
        "Let's keep moving forward.",
        "Onward, straight ahead.",
        "Drive onward.",
        "Can you keep straight?",
        "Steer straight ahead.",
        "Go forward down this path."
    ],
    1: [
        "Pass the intersection.",
        "Could you cross the intersection?",
        "Let's move through the intersection.",
        "Drive past the intersection.",
        "Please navigate past the junction.",
        "Can you cross the junction?",
        "Traverse the junction, please.",
        "Drive through the junction.",
        "Continue past the crossroad.",
        "Let's go past the crossroad.",
        "Cross the intersection straight ahead.",
        "Pass over the junction.",
        "Can you move past the intersection?",
        "Let's advance past the junction.",
        "Could you drive through the crossroad?",
        "Proceed beyond the intersection.",
        "Drive onward through the junction.",
        "Cross over the junction, please.",
        "Proceed through the crossroad.",
        "Move across the intersection."
    ],
    2: [
        "Turn left.",
        "Can you turn to the left?",
        "Please make a left turn.",
        "Let's take a left turn.",
        "Could you steer left?",
        "Make a left turn here.",
        "Turn to the left side.",
        "Shift to the left, please.",
        "Turn left at the next opportunity.",
        "Move into the left direction.",
        "Can you rotate to the left?",
        "Please go left at this point.",
        "Steer left at the intersection.",
        "Take the next left.",
        "Make a left-hand turn.",
        "Turn left onto the next street.",
        "Turn left immediately.",
        "Let's veer left.",
        "Direct your vehicle left.",
        "Left turn ahead."
    ],
    3: [
        "Turn right.",
        "Could you turn to the right?",
        "Please make a right turn.",
        "Let's take a right turn.",
        "Can you steer right?",
        "Make a right turn here.",
        "Turn to the right side.",
        "Shift to the right, please.",
        "Turn right at the next street.",
        "Move into the right direction.",
        "Please rotate to the right.",
        "Take a right-hand turn here.",
        "Steer right at the junction.",
        "Turn right at this point.",
        "Shift right at the next intersection.",
        "Move to the right side now.",
        "Turn right into the next lane.",
        "Make a right-hand turn ahead.",
        "Shift to the rightward lane.",
        "Drive right as soon as possible."
    ],
    4: [
        "Make a left lane change.",
        "Could you switch to the left lane?",
        "Please change to the left lane.",
        "Let's shift to the left lane.",
        "Can you move to the left lane?",
        "Switch lanes to the left.",
        "Steer into the left lane.",
        "Change into the left-hand lane.",
        "Move into the left lane now.",
        "Shift lanes to the left side.",
        "Slide into the left lane.",
        "Please merge into the left lane.",
        "Navigate into the left-hand lane.",
        "Transfer into the left lane.",
        "Shift left into the next lane.",
        "Move to the adjacent left lane.",
        "Can you merge into the left-hand lane?",
        "Switch over to the left lane.",
        "Take the left lane.",
        "Please change lanes left."
    ],
    5: [
        "Make a right lane change.",
        "Could you switch to the right lane?",
        "Please change to the right lane.",
        "Let's shift to the right lane.",
        "Can you move to the right lane?",
        "Switch lanes to the right.",
        "Steer into the right lane.",
        "Change into the right-hand lane.",
        "Move into the right lane now.",
        "Shift lanes to the right side.",
        "Slide into the right lane.",
        "Please merge into the right lane.",
        "Navigate into the right-hand lane.",
        "Transfer into the right lane.",
        "Shift right into the next lane.",
        "Move to the adjacent right lane.",
        "Can you merge into the right-hand lane?",
        "Switch over to the right lane.",
        "Take the right lane.",
        "Please change lanes right."
    ],
    6: [
        "Go to the left lane branch.",
        "Could you take the left lane branch?",
        "Please move into the left lane branch.",
        "Let's follow the left lane branch.",
        "Can you take the left side road?",
        "Turn into the left lane split.",
        "Proceed onto the left branch road.",
        "Drive into the left-hand branch.",
        "Take the left fork.",
        "Follow the left split.",
        "Steer onto the left branch road.",
        "Veer left into the side road.",
        "Can you navigate to the left branch?",
        "Take the upcoming left branch road.",
        "Please follow the left lane division.",
        "Shift into the left fork.",
        "Move into the leftward branch.",
        "Join the left lane divergence.",
        "Turn left into the side lane.",
        "Take the next left lane branch."
    ],
    7: [
        "Go to the right lane branch.",
        "Could you take the right lane branch?",
        "Please move into the right lane branch.",
        "Let's follow the right lane branch.",
        "Can you take the right side road?",
        "Turn into the right lane split.",
        "Proceed onto the right branch road.",
        "Drive into the right-hand branch.",
        "Take the right fork.",
        "Follow the right split.",
        "Steer onto the right branch road.",
        "Veer right into the side road.",
        "Can you navigate to the right branch?",
        "Take the upcoming right branch road.",
        "Please follow the right lane division.",
        "Shift into the right fork.",
        "Move into the rightward branch.",
        "Join the right lane divergence.",
        "Turn right into the side lane.",
        "Take the next right lane branch."
    ],
    8: [
        "Pass the crosswalk.",
        "Could you cross the crosswalk?",
        "Let's traverse the crosswalk.",
        "Drive through the crosswalk.",
        "Please move past the crosswalk.",
        "Continue over the pedestrian crossing.",
        "Navigate across the crosswalk.",
        "Move forward past the crosswalk.",
        "Steer through the pedestrian crossing.",
        "Proceed over the crosswalk.",
        "Can you drive across the crosswalk?",
        "Go ahead past the crosswalk.",
        "Move over the pedestrian path.",
        "Cross over the crosswalk now.",
        "Continue driving over the crosswalk.",
        "Advance past the crosswalk.",
        "Drive ahead through the crosswalk.",
        "Move ahead across the pedestrian path.",
        "Proceed over the pedestrian crossing.",
        "Please pass over the crosswalk."
    ],
    9: [
        "Pass the railroad.",
        "Could you cross the railroad?",
        "Let's traverse the railroad.",
        "Drive through the railroad.",
        "Please move past the railroad.",
        "Proceed over the railroad tracks.",
        "Drive across the railway crossing.",
        "Move past the train tracks.",
        "Navigate over the railroad crossing.",
        "Advance across the railroad.",
        "Can you cross the train tracks?",
        "Go ahead past the railroad.",
        "Move over the railway path.",
        "Cross over the railroad now.",
        "Continue driving over the tracks.",
        "Advance past the railroad tracks.",
        "Drive ahead through the crossing.",
        "Move ahead across the railway path.",
        "Proceed over the railway crossing.",
        "Please pass over the train tracks."
    ],
    10: [
        "Merge.",
        "Could you merge into traffic?",
        "Please join the traffic flow.",
        "Let's merge with the traffic.",
        "Can you merge into the lane?",
        "Blend into the traffic lane.",
        "Join the flow of vehicles.",
        "Move into the ongoing traffic.",
        "Please integrate with the traffic.",
        "Proceed by merging into the lane.",
        "Move into the main traffic stream.",
        "Could you join the lane traffic?",
        "Merge into the ongoing flow.",
        "Can you flow into the lane?",
        "Let’s merge into the moving traffic.",
        "Blend into the driving lane.",
        "Please transition into the traffic flow.",
        "Integrate with the main traffic.",
        "Proceed by joining the lane."
    ],
    11: [
        "Make a U-turn.",
        "Could you do a U-turn?",
        "Please perform a 180-degree turn.",
        "Let's turn around.",
        "Can you drive in a U-turn?",
        "Turn the vehicle around.",
        "Perform a full turn.",
        "Could you rotate the car 180 degrees?",
        "Make a U-turn at the next point.",
        "Turn back in the opposite direction.",
        "Shift into a U-turn here.",
        "Spin around with a U-turn.",
        "Please reverse the vehicle with",
    ],
    12: [
        "Stop.",
        "Could you halt the vehicle?",
        "Please decelerate.",
        "Let's slow down.",
        "Can you apply the brakes?",
        "Bring the car to a stop.",
        "Please come to a halt.",
        "Let's bring the vehicle to a complete stop.",
        "Can you stop the car here?",
        "Pause the vehicle, please.",
        "Come to a stop at this point.",
        "Slow down and stop here.",
        "Reduce speed and stop.",
        "Apply the brakes and halt.",
        "Stop the vehicle immediately.",
        "Brake and bring the car to a stop.",
        "Halt the movement of the vehicle.",
        "Can you pause the vehicle here?",
        "Stop here, please.",
        "Let's come to a halt."
    ],
    13: [
        "Deviate.",
        "Could you change the direction?",
        "Please shift the direction.",
        "Let's deviate from the path.",
        "Can you move away from the lane?",
        "Take an alternate route.",
        "Veer away from this course.",
        "Could you take a different path?",
        "Please shift away from the lane.",
        "Move off the current path.",
        "Let's divert from the main road.",
        "Switch to a new direction.",
        "Move off the intended route.",
        "Take a different course.",
        "Can you deviate from the road?",
        "Change your current course.",
        "Steer off this path.",
        "Can we take a detour?",
        "Adjust your direction.",
        "Let's alter the course."
    ]}


def map_category_to_caption(category_index, diverse=True):
    if diverse:
        return random.choice(diverse_caption_dict[category_index])
    else:
        return plain_caption_dict[category_index]